<!DOCTYPE html>
<html>
<head>
    <title>Wingo 3 Minutes - Latest Result</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; padding: 50px; }
        h1 { font-size: 50px; color: #ff6600; }
        .box { display: inline-block; padding: 30px; border: 2px solid #333; border-radius: 10px; background: #f4f4f4; }
    </style>
    <script>
        async function fetchNumber() {
            try {
                let response = await fetch("wingo_3min.php");
                let data = await response.json();
                document.getElementById("number").innerText = data.winning_number ?? "N/A";
            } catch (e) {
                document.getElementById("number").innerText = "Error";
            }
        }
        setInterval(fetchNumber, 10000);
        window.onload = fetchNumber;
    </script>
</head>
<body>
    <h1>🎯 Wingo 3 Minutes</h1>
    <div class="box">
        <h2>Latest Winning Number:</h2>
        <h1 id="number">Loading...</h1>
    </div>
</body>
</html>
