<?php
header('Content-Type: application/json');
$allowed_ips = [
    "135.181.58.182",  
    "152.59.173.91",
    "65.109.126.37",
    "65.108.9.253",
    "88.198.107.56",
];
$user_ip = $_SERVER['REMOTE_ADDR'];
if (!in_array($user_ip, $allowed_ips)) {
    echo json_encode([
        "error" => "Access Denied: IP Not Whitelisted",
        "your_ip" => $user_ip
    ]);
    exit;
}
$cacheFile = __DIR__ . "/cache_1m.json";
$cacheTime = 5;
if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTime)) {
    echo file_get_contents($cacheFile);
    exit;
}
$apiUrl = "https://draw.ar-lottery01.com/WinGo/WinGo_1M/GetHistoryIssuePage.json?ts=" . time();
$response = file_get_contents($apiUrl);
$data = json_decode($response, true);
if ($data && isset($data['data']['list'][0])) {
    $latest = $data['data']['list'][0];
    $issue = $latest['issue'] ?? null;
    $openTime = $latest['open_time'] ?? null;
    $number = $latest['number'] ?? null;
    
    $result = json_encode([
        "winning_number" => $number,
        "issue" => $issue,
        "open_time" => $openTime
    ]);
    file_put_contents($cacheFile, $result);
    echo $result;
} else {
    echo json_encode(["error" => "Failed to fetch winning number"]);
}
?>
