<?php
header('Content-Type: application/json');
$cacheFile = __DIR__ . "/cache_30s.json";
$cacheTime = 5;  // 5 seconds cache

if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < $cacheTime)) {
    echo file_get_contents($cacheFile);
    exit;
}
$apiUrl = "https://draw.ar-lottery01.com/WinGo/WinGo_30S/GetHistoryIssuePage.json?ts=" . time();
$response = file_get_contents($apiUrl);
$data = json_decode($response, true);

if ($data && isset($data['data']['list'][0])) {
    $latest = $data['data']['list'][0];
    $result = json_encode(["winning_number" => $latest['number']]);
    file_put_contents($cacheFile, $result);
    echo $result;
} else {
    echo json_encode(["error" => "Failed to fetch winning number"]);
}
?>
